FasdUAS 1.101.10        
  k           
  l            Add keywords from the JPEG comment to either the iPhoto keywords or the title of the photo.  The keywords are expected to be contained in the JPEG comment field as a comma separated list.       	
  l      
   
 E ? Usage: select one or more photos in iPhoto and run the script.    	   
  l      
   
 B < Note: UI Scripting must be enabled for this script to work.       
  l           ~ Note: We expect to be able to create the directory that temp_folder is set to and write to it.  The directory must not exist.       
  l          t n Note: The command line tool "jhead" must be installed and the variabel jhead_bin must be set to its location.       
  l             
  l          * $ Copyright 2006 by Patrick Stahlberg       
  l             
  p          
0 	jhead_bin        
  l      
   r      ! "
 ! m      # #  /opt/local/bin/jhead   
 " o       
0 	jhead_bin       $ %
 $ p       & &  0 temp_folder     %  ' (
 ' l    )
 ) r     * +
 * m     , ,  
/tmp/pic_temp   
 + o       0 temp_folder     (  - .
 - l          .  / 0
 / l      1   1   Delays for UI scripting.    0  2 3
 2 l    4
 4 r     5 6
 5 m    	 7 7 ?      
 6 o       <0 delayafteropeningpreferences delayAfterOpeningPreferences   3  8 9
 8 l    :
 : r     ; <
 ; m    
 = = ?ffffff
 < o       >0 delayafterswitchingtokeywords delayAfterSwitchingToKeywords   9  > ?
 > l    @
 @ r     A B
 A m     C C ?      
 B o       40 delayaftertypingakeyword delayAfterTypingAKeyword   ?  D E
 D l    F
 F r     G H
 G m     I I ?ffffff
 H o       $0 delayafterreturn delayAfterReturn   E  J K
 J l          K  L M
 L l   ( N
 N O    ( O P
 O k    ' Q Q  R S
 R I   !
 .miscactvnull  null     S  T
 T r   " ' U V
 U m   " #
 vieworga
 V l      W
 W 1   # &
 
view    
 P m     X Xnull         
iPhoto.app p2 hp2 h  p2    `        iPho   alis    L  Macintosh HD               qFH+     
iPhoto.app                                                      sZb˩          	                Applications    qI      c         $Macintosh HD:Applications:iPhoto.app   
 i P h o t o . a p p    M a c i n t o s h   H D  Applications/iPhoto.app   /      M  Y Z
 Y l          Z  [ \
 [ l  ) 3 ]
 ] s   ) 3 ^ _
 ^ l  ) . `
 ` n  ) . a b
 a I   * .  0 selectedimages SelectedImages    
 b  f   ) *  
 _ o       0 selected_photos     \  c d
 c l          d  e f
 e l  4 d g
 g Z   4 d h i
 h =   4 = j k
 j l  4 ; l
 l I  4 ; m
 .corecnte****       ****
 m o   4 7 0 selected_photos      
 k m   ; <  
 i O  @ ` n o
 n I  D _ p q
 .sysodlogaskr        TEXT
 p m   D G r r ' !Please select one or more photos.    q  s t
 
btns
 s v   J O u u  v
 v m   J M w w  OK      t  x y
 
disp
 x m   R U
 stic     y  z
 
dflt
 z m   X Y   
 o m   @ A X       f  { |
 { l          |  } ~
 } l  ep 
  Y   ep   
  k   uk     
  r   u   
  n   u }  
  4   x } 
 
cobj
  o   { | 0 i  
  o   u x 0 selected_photos  
  o       0 
this_photo      
  l           
  O     
  I    
 .iPhoisalnull    obj 
  o     0 
this_photo    
  m     X    
  l           
  l        &   Get keywords from JPEG comment.       
  r      
  I     "0 extractkeywords ExtractKeywords     
 
from
  o     0 
this_photo    
  o       0 keyword_list      
  l           
  l        ) # Determine if any keywords are new.       
  r      
  I      &0 createnewkeywords CreateNewKeywords
   f       
 
from
  o     0 keyword_list    
  o       0 res      
  l           
  l          Add keywords to photo.      
  O   k  
  k   j     
  I    
 .iPhoisalnull    obj 
  o     0 
this_photo       
  Z   j   
  F      
  =      
  o     0 res  
  m        ok   
  ?      
  l    
  I    
 .corecnte****       ****
  o     0 keyword_list      
  m      
  k   
     
  l           Assign keywords to photo.       
  I    
 .iPhoisalnull    obj 
  o     0 
this_photo       
  Y   
   
  k        
  r      
  n      
  4     
 
cobj
  o     0 j  
  o     0 keyword_list  
  o       0 this_keyword     
  I   
 .iPhoakwdnull    obj      
 
ikst
  o    0 this_keyword       0 j  
  m    ~~ 
  l    }
  I   | {
| .corecnte****       ****
  o    zz 0 keyword_list  {  }          
  =  
  
  o  
yy 0 res  
  m      title      x
  k  f     
  l w w      Assign title to photo.       
  r  "  
  n   
  1  v
v 
txdl
  1  u
u 
ascr
  o      tt 0 old_delimiters      
  r  #0  
  J  #(    s
  m  #&    ,    s  
  n       
  1  +/r
r 
txdl
  1  (+q
q 
ascr    
  O 1N  
  r  7M  
  b  7I  
  4  7=p 
p 
cobj
  m  ;<oo 
  l =H n
  b  =H  
  J  =B    m
  m  =@      m  
  1  BGl
l 
restn  
  o      kk 0 title_string  
  o  14jj 0 keyword_list    
 r  OZ
 o  ORii 0 old_delimiters  
 n     
 1  UYh
h 
txdl
 1  RUg
g 
ascr f
 r  [f	

	 o  [^ee 0 title_string  

 l     d
 n      

 1  aec
c 
titl

 o  ^abb 0 
this_photo  d  f  x      
  m     X   0 i  
  m   h iaa 
  l  i p`
 I  i p_^
_ .corecnte****       ****
 o   i l]] 0 selected_photos  ^  `       ~ 
 l     \[\  [   
 l     ZYZ  Y   
 l     XX     Looks for keywords that don't already exist in the iPhoto keyword list and creates them.  Before creating, the user is asked and also given the choice to skip the current photo or add the keywords into the iPhoto comment field of the photo.    
 l     WW     Input: list of keywords    
 l     VV     Output:    
 l     UU   = 7 "donothing": Do nothing.  User asked us to do nothing.     !
  l     T"T  " I C "title": User asked to add the keywords as the title of the photo.   ! #$
# l     S%S  % F @ "ok": Keywords are added and are ready to be assigned to photo.   $ &'
& i    ()
( I      RQ*R &0 createnewkeywords CreateNewKeywordsQ  * P+O
P 
from
+ o      NN 0 keyword_list  O  
) k    ,, -.
- O    /0
/ r    12
1 n    	34
3 1    	M
M 
pnam
4 n    56
5 2    L
L 
ikwd
6 m     X
2 o      KK 0 existing_keywords  
0 m      X. 78
7 l  
 
JIJ  I  8 9:
9 l  
 
H;H  ; $  Get the list of new keywords.   : <=
< r   
 >?
> J   
 GG  
? o      FF 0 new_keywords  = @A
@ Y    <BECDD
B Z   ! 7EFCB
E H   ! (G
G E   ! 'HI
H o   ! "AA 0 existing_keywords  
I l  " &J@
J n   " &KL
K 4   # &?M
? 
cobj
M o   $ %>> 0 i  
L o   " #== 0 keyword_list  @  
F r   + 3NO
N b   + 1PQ
P o   + ,<< 0 new_keywords  
Q l  , 0R;
R n   , 0ST
S 4   - 0:U
: 
cobj
U o   . /99 0 i  
T o   , -88 0 keyword_list  ;  
O o      77 0 new_keywords  C  B  E 0 i  
C m    66 
D n    VW
V m    5
5 
nmbr
W n   XY
X 2   4
4 
cobj
Y o    33 0 keyword_list  D  A Z[
Z l  = =212  1  [ \]
\ Z   = M^_0/
^ =   = D`a
` l  = Bb.
b I  = B-c,
- .corecnte****       ****
c o   = >++ 0 new_keywords  ,  .  
a m   B C**  
_ L   G Id
d m   G Hee  ok   0  /  ] fg
f l  N N)()  (  g hi
h O   N jk
j k   R ll mn
m I  R W'&%
' .miscactvnull  null&  %  n op
o r   X ]qr
q n  X [st
s 1   Y [$
$ 
txdl
t 1   X Y#
# 
ascr
r o      "" 0 old_delimiters  p uv
u r   ^ ewx
w J   ^ ayy z!
z m   ^ _{{  ,    !  
x n     |}
| 1   b d 
  
txdl
} 1   a b
 
ascrv ~
~ I  f }
 .sysodlogaskr        TEXT
 b   f i
 m   f g " Add the following keywords:    
 o   g h 0 new_keywords   
 
btns
 v   j o 
 m   j k 	 Yes    
 m   k l  No    
 m   l m ! Assign to the photo's title      
 
disp
 m   r s  
 
dflt
 m   v w    
 r   ~ 
 n   ~ 
 1    
 
bhit
 l  ~ 
 1   ~ 
 
rslt  
 o       0 res   
 r    
 o     0 old_delimiters  
 n     
 1    
 
txdl
 1    
 
ascr 
 Z    

 =    
 o     0 res  
 m      No   
 L    
 m      	donothing    
 =    
 o     0 res  
 m     ! Assign to the photo's title    

 L    
 m      title   
  
    
k m   N O Xi 
 l   		     
 l        Add the keywords.	    
 O   
 O   
 k    
 l        Open preferences window.    
 I   
 .prcskprsnull    utxt
 m      ,    
 
faal
 J     
 m    
 eMdsKcmd     
 I    
  .sysodelanull  nmbr
 n   
 o     <0 delayafteropeningpreferences delayAfterOpeningPreferences
  f       
 l      * $ Switch to keywords preference pane.    
 I   
 .prcsclicuiel     uiel
 n    
 4    
 
butT
 m      Keywords   
 n    
 4    
 
tbar
 m     
 4    
 
cwin
 m         
 I   
 .sysodelanull  nmbr
 n   
 o     >0 delayafterswitchingtokeywords delayAfterSwitchingToKeywords
  f       
 l        Add keywords.    
 r    
 J      
 o       0 created_keywords   
 Y   n
 k  i 
 r  
 n  
 4  
 
cobj
 o   0 i  
 o   0 new_keywords  
 o       0 current_keyword   
 Z  i
 H  
 E  
 o   0 created_keywords  
 o   0 current_keyword  
 k  e 
 O  _
 O  &^ 
 k  /] 
 I /;
 .prcsclicuiel     uiel
 4  /7
 
butT
 m  36  +      
 I <A	
 .prcskprsnull    utxt
	 o  <= 0 current_keyword     


 I BK
 .sysodelanull  nmbr
 n BG


 o  CG 40 delayaftertypingakeyword delayAfterTypingAKeyword
  f  BC   
 I LS
 .prcskprsnull    utxt
 o  LO
 
ret    
 I T]
 .sysodelanull  nmbr
 n TY
 o  UY $0 delayafterreturn delayAfterReturn
  f  TU    
  4  &,
 
sgrp
 m  *+ 
 4  #
 
cwin
 m  !"  
 l ``   0 * Add keyword to list of existing keywords.    
 r  `e
 b  `c
 o  `a 0 created_keywords  
 o  ab 0 current_keyword  
 o       0 created_keywords           0 i  
 m   
 n  
 !
  m  	
 
nmbr
! n "#
" 2 
 
cobj
# o   0 new_keywords     $%
$ l oo&  & 0 * Hit escape to exit the properties window.   % '
' O  o()
( I x*
 .prcskcodnull    long
* m  x{ 5  
) 4  ou+
 
cwin
+ m  st   
 4    ,
 
prcs
, m    --  iPhoto   
 m    ..null        System Events.app8   8    `        sevs   alis      Macintosh HD               qFH+    System Events.app                                                n
SL          	                CoreServices    qI      
        f  e  :Macintosh HD:System:Library:CoreServices:System Events.app  $  S y s t e m   E v e n t s . a p p    M a c i n t o s h   H D  -System/Library/CoreServices/System Events.app   /    /0
/ l     0 1
1 L  2
2 m  33  ok     ' 45
4 l         5 67
6 l     8  8 J D Resolve the file name to the original file.  This means two things:   7 9:
9 l     ;  ; w q - If the file is in the "Modified" directory, change it the the corresponding file in the "Originals" directory.   : <=
< l     >  > V P - If the file is an alias, resolve it to the original file the alias points to.   = ?@
? l     A  A 2 , Input: File name in POSIX form as a string.   @ BC
B l     D  D 3 - Output: File name in POSIX form as a string.   C EF
E i   GH
G I      I &0 resolvedfilealias ResolvedFileAlias  I J
 
from
J o       
0 	file_name    
H k     KK LM
L l     N  N 6 0 Replace "Modified" with "Original" if possible.   M OP
O Z     =QR
Q E     ST
S o      
0 	file_name  
T m    UU  Modified   
R k    9VV WX
W r    YZ
Y n   	[\
[ 1    	
 
txdl
\ 1    
 
ascr
Z o       0 old_delimiters  X ]^
] r    _`
_ J    aa b
b m    
cc  Modified     
` n     de
d 1    
 
txdl
e 1    
 
ascr^ fg
f r    hi
h n   jk
j 2   
 
citm
k o     
0 	file_name  
i o       
0 	file_name  g lm
l r    !no
n J    pp q
q m    rr  	Originals     
o 1     
 
txdlm st
s O  " 3uv
u r   & 2wx
w b   & 0yz
y  :   & (
z l  ( /{
{ b   ( /|}
| J   ( +~~ 
 m   ( )        
} 1   + .
 
rest  
x o       
0 	file_name  
v o   " # 
0 	file_name  t 
 r   4 9
 o   4 5 0 old_delimiters  
 n     
 1   6 8
 
txdl
 1   5 6
 
ascr      P 
 l  > >     
 l  > >   7 1 Resolve to original file in case it is an Alias.    
 l  > >   This is done in an extremely complicated manner, because the Finder's "original item" function does not work if the alias sits in a FileVault volume.  Our workaround is to copy the alias to a temporary location outside of the FileVault volume, and then use "original item".    
 r   > F
 c   > D
 l  > B
 4   > B
 
psxf
 o   @ A 
0 	file_name    
 m   B C
 
alis
 o       0 fn   
 Z   G 
 l  G P
 =  G P
 n   G N
 m   L N
 
alis
 l  G L
 I  G L
 .sysonfo4asfe       ****
 o   G H 0 fn      
 m   N O
 boovtrue  
 k   S  
 r   S n
 I  S l
 .sysoexecTEXT     TEXT
 b   S h
 b   S d
 b   S `
 b   S ^
 b   S Z
 b   S X
 m   S T  mkdir    
 n   T W
 1   U W
 
strq
 o   T U 0 temp_folder  
 m   X Y   && echo -n    
 n   Z ]
 1   [ ]
 
strq
 o   Z [ 0 temp_folder  
 m   ^ _  /`basename    
 n   ` c
 1   a c
 
strq
 o   ` a 
0 	file_name  
 m   d g  `     
 o      ~~ 0 temp_file_name   
 r   o w
 c   o u
 4   o s}
} 
psxf
 o   q r|| 0 temp_folder  
 m   s t{
{ 
alis
 o      zz 0 
target_folder   
 O   x 
 k   ~  
 I  ~ y
y .coreclon****       ****
 o   ~ xx 0 fn   wv
w 
insh
 o    uu 0 
target_folder  v   
 r    
 4    t
t 
cobj
 l   s
 c    
 4    r
r 
psxf
 o    qq 0 temp_file_name  
 m    p
p 
aliss  
 o      oo 0 fn   
 r    
 c    
 l   n
 n    
 1    m
m 
orig
 o    ll 0 fn  n  
 m    k
k 
ctxt
 o      jj 0 fn   
 l   ii     This line (as well as the "as text" in the line above is nesessary due to another Finder bug.  Just doing "set file_name to POSIX path of fn" does not work.    h
 r    
 c    
 o    gg 0 fn  
 m    f
f 
alis
 o      ee 0 fn  h  
 m   x {null     ߀  
Finder.app  8 H 8 H   8    `        MACS   alis    r  Macintosh HD               qFH+    
Finder.app                                                       EL
P          	                CoreServices    qI      
        f  e  3Macintosh HD:System:Library:CoreServices:Finder.app    
 F i n d e r . a p p    M a c i n t o s h   H D  &System/Library/CoreServices/Finder.app  /    
 r    
 n    
 1    d
d 
psxp
 o    cc 0 fn  
 o      bb 
0 	file_name   a
 I   `_
` .sysoexecTEXT     TEXT
 b    
 m      rm -r    
 n    
 1    ^
^ 
strq
 o    ]] 0 temp_folder  _  a       
 l   \[\  [   Z
 L    
 o    YY 
0 	file_name  Z  F 
 l     XWX  W   
 l     VUV  U   
 l     T T      Extract keywords from the photo.  Determines the filename of the original photo, and extracts the JPEG comment string using jhead.  Then, separates the string into a list of keywords.    
 l     SS   "  Input: iPhoto photo handle.    
 l     RR     Output: List of strings.    
 i   	

	 I      QPQ "0 extractkeywords ExtractKeywordsP   ON
O 
from
 o      MM 0 
this_photo  N  

 k     

 
 O    

 r    	
 l   L
 n    
 1    K
K 
ipth
 o    JJ 0 
this_photo  L  
 o      II 
0 	file_name  
 m      X 
 l   HGH  G   
 r    
 I   FEF &0 resolvedfilealias ResolvedFileAliasE   DC
D 
from
 o   
 BB 
0 	file_name  C  
 o      AA 
0 	file_name    
 l   @?@  ?    !"
! l   >#>  # C = Use jhead to get the JPEG comment and do some preprocessing.   " $%
$ r    $&'
& I   "=(<
= .sysoexecTEXT     TEXT
( b    )*
) b    +,
+ b    -.
- o    ;; 
0 	jhead_bin  
. m    //      
, n    01
0 1    :
: 
strq
1 o    99 
0 	file_name  
* m    22 X R| perl -ne 's/^Comment +: +(.*?) *$/$1/ && {$f=1}; s/, */,/g; chomp; $f && print;'   <  
' o      88 0 res  % 34
3 l  % %767  6  4 56
5 l  % %575  7 B < We now have one line, and the keywords are comma-separated.   6 89
8 r   % *:;
: n  % (<=
< 1   & (4
4 
txdl
= 1   % &3
3 
ascr
; o      22 0 old_delimiters  9 >?
> r   + 2@A
@ J   + .BB C1
C m   + ,DD  ,   1  
A n     EF
E 1   / 10
0 
txdl
F 1   . //
/ 
ascr? GH
G r   3 8IJ
I n   3 6KL
K 2  4 6.
. 
citm
L o   3 4-- 0 res  
J o      ,, 0 keyword_list  H MN
M r   9 >OP
O o   9 :++ 0 old_delimiters  
P n     QR
Q 1   ; =*
* 
txdl
R 1   : ;)
) 
ascrN ST
S l  ? ?('(  '  T UV
U r   ? CWX
W J   ? A&&  
X o      %% 0 
final_list  V YZ
Y Y   D [$\]#
[ k   R ^^ _`
_ r   R Xab
a n   R Vcd
c 4   S V"e
" 
cobj
e o   T U!! 0 i  
d o   R S   0 keyword_list  
b o       0 this_keyword  ` fg
f Z   Y thi
h G   Y hjk
j =   Y \lm
l o   Y Z 0 this_keyword  
m m   Z [nn  ?   
k E   _ dop
o o   _ ` 0 this_keyword  
p m   ` cqq  ??   
i r   k prs
r m   k ntt  ??   
s o       0 this_keyword      g u
u Z   u vw
v F   u xy
x >  u zz{
z o   u v 0 this_keyword  
{ m   v y||      
y >  } }~
} o   } ~ 0 this_keyword  
~ m   ~   SANE data follows   
w r    
 b    
 o     0 
final_list  
 o     0 this_keyword  
 o       0 
final_list        $ 0 i  
\ m   G H 
] I  H M
 .corecnte****       ****
 o   H I 0 keyword_list    #  Z 
 l   

     
 L    
 o    

 0 
final_list     
 l     		     
 l        N H------------------------------------------------------------------------    
 l        5 / The following function was copied from Apple's    
 l          sample scripts at    
 l        F @ http://www.apple.com/applescript/guidebook/sbrt/pgs/sbrt.07.htm    
 l        / ) http://www.apple.com/applescript/iphoto/    
 l        N H------------------------------------------------------------------------    
 l            
 i    
 I        0 selectedimages SelectedImages    
 O     .
 Q    -
 k    # 
 l        get selection    
 r    
 l   

 1    

 
selc  
 o       0 these_items   
 l  
 
   &   check for single album selected    
 Z  
  
 =  
 
 l  
 
 n   
 
 1    
 
pcls
 n   
 
 4    
 
cobj
 m     
 o   
  0 these_items    
 m    
 
ipal
 R    
 .ascrerr ****       ****         
 l  ! !   ) # return the list of selected photos    
 L   ! #
 o   ! " 0 these_items    
 R      
 .ascrerr ****       ****    
 L   + -
 m   + ,
 boovfals
 m      X 
 l                 # , 7 = C =e    &0 createnewkeywords CreateNewKeywords &0 resolvedfilealias ResolvedFileAlias "0 extractkeywords ExtractKeywords  0 selectedimages SelectedImages
 .aevtoappnull      **** 
0 	jhead_bin   0 temp_folder   <0 delayafteropeningpreferences delayAfterOpeningPreferences >0 delayafterswitchingtokeywords delayAfterSwitchingToKeywords 40 delayaftertypingakeyword delayAfterTypingAKeyword $0 delayafterreturn delayAfterReturn 0 selected_photos   0 
this_photo   0 keyword_list   0 res   0 old_delimiters   0 title_string   0 this_keyword       ) &0 createnewkeywords CreateNewKeywords   
 
from 0 keyword_list      0 keyword_list   0 existing_keywords   0 new_keywords   0 i   0 old_delimiters   0 res   0 created_keywords   0 current_keyword   1 Xe{.-3
 
ikwd
 
pnam
 
cobj
 
nmbr
 .corecnte****       ****
 .miscactvnull  null
 
ascr
 
txdl
 
btns
 
disp
 
dflt 
 .sysodlogaskr        TEXT
 
rslt
 
bhit
 
prcs
 
faal
 eMdsKcmd
 .prcskprsnull    utxt <0 delayafteropeningpreferences delayAfterOpeningPreferences
 .sysodelanull  nmbr
 
cwin
 
tbar
 
butT
 .prcsclicuiel     uiel >0 delayafterswitchingtokeywords delayAfterSwitchingToKeywords
 
sgrp 40 delayaftertypingakeyword delayAfterTypingAKeyword
 
ret  $0 delayafterreturn delayAfterReturn 5
 .prcskcodnull    long 	-,EUOjvEO )k-,Ekh / 
/%EY h[OYOj j  Y hO ]*j O,EOkv,FO%m
a la ka  O_ a ,EO,FOa   	a Y a   	a Y hUOa  *a a / a a a kvl  O)a !,j "O*a #j/a $k/a %a &/j 'O)a (,j "OjvEO mk-,Ekh /EO M*a #k/ :*a )k/ 0*a %a */j 'Oj  O)a +,j "O_ ,j  O)a -,j "UUO%EY h[OYO*a #k/ 	a .j /UUUOa 0 H &0 resolvedfilealias ResolvedFileAlias   
 
from 
0 	file_name      
0 	file_name   0 old_delimiters   0 fn   0 temp_file_name   0 
target_folder   Ucr
 
ascr
 
txdl
 
citm
 
rest
 
psxf
 
alis
 .sysonfo4asfe       **** 0 temp_folder  
 
strq
 .sysoexecTEXT     TEXT
 
insh
 .coreclon****       ****
 
cobj
 
orig
 
ctxt
 
psxp Ġ 8,EOkv,FO-EOkv*,FO *5kv*,%%EUO,FY hO*/&EOj 
,e  n,%%,%%,%a %j EO*/&EOa  +a l O*a */&/EOa ,a &EO&EUOa ,EOa ,%j Y hO 
~} "0 extractkeywords ExtractKeywords  ~ |{z
| 
from{ 0 
this_photo  z   yxwvutsry 0 
this_photo  x 
0 	file_name  w 0 res  v 0 old_delimiters  u 0 keyword_list  t 0 
final_list  s 0 i  r 0 this_keyword    Xqpon/m2lkjDihgnqft|
q 
ipth
p 
fromo &0 resolvedfilealias ResolvedFileAliasn 
0 	jhead_bin  
m 
strq
l .sysoexecTEXT     TEXT
k 
ascr
j 
txdl
i 
citm
h .corecnte****       ****
g 
cobj
f 
bool}  ,EUO*l EO%,%%j EO,EOkv,FO-EO,FOjvEO Rkj 
kh /EO 
 a a & 
a EY hOa 	 a a & 
%EY h[OYO edcbe  0 selectedimages SelectedImagesd  c   aa 0 these_items    X`_^]\[
` 
selc
_ 
cobj
^ 
pcls
] 
ipal\  [  b / + !*,EOk/,  	)jhY hOW 	X  fU ZYXW
Z .aevtoappnull      ****
 k    p    '  2  8  >  D  L  [  e  }VV  Y  X   UTU 0 i  T 0 j   0 #S ,R 7Q =P CON XMLKJIH rG wFEDCBA@?>=<;: 9876 543 210S 
0 	jhead_bin  R 0 temp_folder  Q <0 delayafteropeningpreferences delayAfterOpeningPreferencesP >0 delayafterswitchingtokeywords delayAfterSwitchingToKeywordsO 40 delayaftertypingakeyword delayAfterTypingAKeywordN $0 delayafterreturn delayAfterReturn
M .miscactvnull  null
L vieworga
K 
viewJ  0 selectedimages SelectedImagesI 0 selected_photos  
H .corecnte****       ****
G 
btns
F 
disp
E stic    
D 
dfltC 
B .sysodlogaskr        TEXT
A 
cobj@ 0 
this_photo  
? .iPhoisalnull    obj 
> 
from= "0 extractkeywords ExtractKeywords< 0 keyword_list  ; &0 createnewkeywords CreateNewKeywords: 0 res  
9 
bool8 0 this_keyword  
7 
ikst
6 .iPhoakwdnull    obj 
5 
ascr
4 
txdl3 0 old_delimiters  
2 
rest1 0 title_string  
0 
titlWqEOEOEOEOEOEO 
*j O*,FUO)j+ EQ` O_ j j  % a a a k
a a a ka  UY hO
k_ j kh  _ a /E` O 	_ j UO*a _ l E` O)a _ l  E` !O _ j O_ !a " 	 _ j ja #& :_ j O ,k_ j kh _ a /E` $O*a %_ $l &[OYY __ !a '  T_ (a ),E` *Oa +kv_ (a ),FO_  *a k/a ,kv*a -,%%E` .UO_ *_ (a ),FO_ ._ a /,FY hU[OY //      X.-
. 
ipmr A Yp  
- kfrmID     X,+
, 
ipmr A Y  
+ kfrmID     X*)
* 
ipmr A Y  
) kfrmID   ((      S t e p h a n i e ''     ,      | M a t t ,   S i m o n ,   B i l l y ,   B e n n a ,   D a v i d ,   Y l a n n ,   J u l i a ,   P a t r i c k ,   S t e p h    ascr  ޭ